VERSION 5.00
Object = "{7C7685C7-677A-4F5E-889F-AA3756D92A19}#1.0#0"; "Logox4Cntrl.dll"
Begin VB.Form Logox4TestApplicationForm 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Logox4 Test Application"
   ClientHeight    =   7635
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   10845
   ControlBox      =   0   'False
   Icon            =   "Logox4TestApplication.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   7635
   ScaleWidth      =   10845
   StartUpPosition =   3  'Windows Default
   Begin VB.ListBox Notification 
      Height          =   1815
      ItemData        =   "Logox4TestApplication.frx":000C
      Left            =   360
      List            =   "Logox4TestApplication.frx":000E
      TabIndex        =   37
      Top             =   4560
      Width           =   6735
   End
   Begin VB.CommandButton CloseButton 
      Caption         =   "Close"
      Height          =   375
      Left            =   9480
      TabIndex        =   36
      Top             =   7080
      Width           =   1095
   End
   Begin VB.CommandButton ClearButton 
      Caption         =   "Clear"
      Height          =   375
      Left            =   240
      TabIndex        =   35
      Top             =   7080
      Width           =   1095
   End
   Begin VB.Frame Frame3 
      Caption         =   "Notifications"
      Height          =   2775
      Left            =   240
      TabIndex        =   22
      Top             =   4200
      Width           =   10335
      Begin VB.CheckBox GlobalNotification 
         Caption         =   "enable global notifications"
         Height          =   255
         Left            =   120
         TabIndex        =   34
         Top             =   2400
         Width           =   4335
      End
      Begin VB.TextBox ActionID 
         Alignment       =   2  'Center
         Height          =   285
         Left            =   8160
         TabIndex        =   33
         Text            =   "0"
         Top             =   2040
         Width           =   975
      End
      Begin VB.CheckBox Action 
         Caption         =   "Actions"
         Height          =   255
         Left            =   8520
         TabIndex        =   31
         Top             =   1440
         Value           =   1  'Checked
         Width           =   1335
      End
      Begin VB.CheckBox Bookmark 
         Caption         =   "Bookmarks"
         Height          =   255
         Left            =   8520
         TabIndex        =   30
         Top             =   1200
         Value           =   1  'Checked
         Width           =   1335
      End
      Begin VB.CheckBox Param 
         Caption         =   "Params"
         Height          =   255
         Left            =   8520
         TabIndex        =   29
         Top             =   960
         Value           =   1  'Checked
         Width           =   1335
      End
      Begin VB.CheckBox Chunk 
         Caption         =   "Chunks"
         Height          =   255
         Left            =   8520
         TabIndex        =   28
         Top             =   720
         Value           =   1  'Checked
         Width           =   1335
      End
      Begin VB.CheckBox Viseme 
         Caption         =   "Visemes"
         Height          =   255
         Left            =   7320
         TabIndex        =   27
         Top             =   1440
         Value           =   1  'Checked
         Width           =   1335
      End
      Begin VB.CheckBox Mouth 
         Caption         =   "Mouth"
         Height          =   255
         Left            =   7320
         TabIndex        =   26
         Top             =   1200
         Value           =   1  'Checked
         Width           =   1335
      End
      Begin VB.CheckBox Word 
         Caption         =   "Words"
         Height          =   255
         Left            =   7320
         TabIndex        =   25
         Top             =   960
         Value           =   1  'Checked
         Width           =   1335
      End
      Begin VB.CheckBox Sentence 
         Caption         =   "Sentences"
         Height          =   255
         Left            =   7320
         TabIndex        =   24
         Top             =   720
         Value           =   1  'Checked
         Width           =   1335
      End
      Begin VB.Label Label3 
         Caption         =   "ActionID"
         Height          =   255
         Left            =   7320
         TabIndex        =   32
         Top             =   2080
         Width           =   975
      End
      Begin VB.Label Label2 
         Caption         =   "enable notifications of this types:"
         Height          =   255
         Left            =   7320
         TabIndex        =   23
         Top             =   360
         Width           =   2775
      End
   End
   Begin VB.CommandButton ResetButton 
      Caption         =   "Reset"
      Height          =   375
      Left            =   9480
      TabIndex        =   21
      ToolTipText     =   "Reset to default"
      Top             =   3600
      Width           =   1095
   End
   Begin VB.CommandButton RecordButton 
      Caption         =   "Record"
      Height          =   375
      Left            =   3840
      TabIndex        =   20
      ToolTipText     =   "Record from Textedit"
      Top             =   3600
      Width           =   1095
   End
   Begin VB.CommandButton PauseButton 
      Caption         =   "Pause"
      Height          =   375
      Left            =   2640
      TabIndex        =   19
      ToolTipText     =   "Pause the output"
      Top             =   3600
      Width           =   1095
   End
   Begin VB.CommandButton StopButton 
      Caption         =   "Stop"
      Height          =   375
      Left            =   1440
      TabIndex        =   18
      ToolTipText     =   "Stop the output"
      Top             =   3600
      Width           =   1095
   End
   Begin VB.CommandButton SpeakButton 
      Caption         =   "Speak"
      Height          =   375
      Left            =   240
      TabIndex        =   17
      ToolTipText     =   "Speak the text from textedit"
      Top             =   3600
      Width           =   1095
   End
   Begin VB.CheckBox SentenceMark 
      Caption         =   "SentenceMark"
      Height          =   255
      Left            =   360
      TabIndex        =   2
      Top             =   3120
      Width           =   1575
   End
   Begin VB.TextBox Text 
      Height          =   2415
      Left            =   360
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   1
      Text            =   "Logox4TestApplication.frx":0010
      ToolTipText     =   "Enter Text you wish spoken here"
      Top             =   600
      Width           =   4455
   End
   Begin VB.Frame Frame1 
      Caption         =   "Text"
      Height          =   3255
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   4695
   End
   Begin VB.Frame Frame2 
      Caption         =   "Settings"
      Height          =   3255
      Left            =   5160
      TabIndex        =   3
      Top             =   240
      Width           =   5415
      Begin VB.CommandButton SpeechFontButton 
         Caption         =   "..."
         Height          =   300
         Left            =   4800
         TabIndex        =   16
         ToolTipText     =   "List of SpeechFonts"
         Top             =   300
         Width           =   375
      End
      Begin VB.ComboBox SpeechFontCombo 
         Height          =   315
         Left            =   2040
         Style           =   2  'Dropdown List
         TabIndex        =   15
         ToolTipText     =   "Change SpechFont"
         Top             =   300
         Width           =   2775
      End
      Begin VB.HScrollBar RoughnessScroll 
         Height          =   255
         LargeChange     =   10
         Left            =   2040
         Max             =   100
         TabIndex        =   14
         Top             =   2760
         Width           =   3135
      End
      Begin VB.HScrollBar IntonationScroll 
         Height          =   255
         LargeChange     =   30
         Left            =   2040
         Max             =   300
         TabIndex        =   13
         Top             =   2280
         Value           =   100
         Width           =   3135
      End
      Begin VB.HScrollBar SpeedScroll 
         Height          =   255
         LargeChange     =   30
         Left            =   2040
         Max             =   300
         Min             =   10
         TabIndex        =   12
         Top             =   1800
         Value           =   100
         Width           =   3135
      End
      Begin VB.HScrollBar PitchScroll 
         Height          =   255
         LargeChange     =   20
         Left            =   2040
         Max             =   100
         Min             =   -100
         TabIndex        =   11
         Top             =   1320
         Width           =   3135
      End
      Begin VB.HScrollBar VolumeScroll 
         Height          =   255
         LargeChange     =   12
         Left            =   2040
         Max             =   12
         Min             =   -98
         TabIndex        =   10
         Top             =   840
         Width           =   3135
      End
      Begin VB.Label RoughnessLabel 
         Caption         =   "Roughness:"
         Height          =   255
         Left            =   240
         TabIndex        =   9
         Top             =   2760
         Width           =   1935
      End
      Begin VB.Label IntonationLabel 
         Caption         =   "Intonation:"
         Height          =   255
         Left            =   240
         TabIndex        =   8
         Top             =   2280
         Width           =   1935
      End
      Begin VB.Label SpeedLabel 
         Caption         =   "Speed:"
         Height          =   255
         Left            =   240
         TabIndex        =   7
         Top             =   1800
         Width           =   1935
      End
      Begin VB.Label PitchLabel 
         Caption         =   "Pitch:"
         Height          =   255
         Left            =   240
         TabIndex        =   6
         Top             =   1320
         Width           =   1935
      End
      Begin VB.Label VolumeLabel 
         Caption         =   "Volume:"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   840
         Width           =   1935
      End
      Begin VB.Label Label1 
         Caption         =   "SpeechFont:"
         Height          =   255
         Left            =   240
         TabIndex        =   4
         Top             =   360
         Width           =   1215
      End
   End
   Begin LOGOX4CNTRLLibCtl.Logox4Control Logox4 
      Left            =   5160
      OleObjectBlob   =   "Logox4TestApplication.frx":0040
      Top             =   3600
   End
End
Attribute VB_Name = "Logox4TestApplicationForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim ApplicationName As String

Private Sub ClearButton_Click()
    Notification.Clear
End Sub

Private Sub CloseButton_Click()
    ok = Logox4.SaveSettings(ApplicationName)
    Logox4.Disconnect
    End
End Sub

Private Sub Form_Load()
    ApplicationName = "Logox4 Test Application"
    
    ok = Logox4.Initialize
    ok = Logox4.LoadSettings(ApplicationName)
    
    SpeechFontCombo.Clear
    
    Fonts = Logox4.GetNumberOfFonts
    For nth = 0 To Fonts - 1
        SpeechFontCombo.AddItem (Logox4.GetFontName(nth))
    Next
    SpeechFontCombo.ListIndex = Logox4.GetLocalFont
    
    VolumeScroll.Value = Logox4.GetLocalVolume / 10
    VolumeScroll_Change
    PitchScroll.Value = Logox4.GetLocalPitch / 10
    PitchScroll_Change
    SpeedScroll.Value = Logox4.GetLocalSpeed
    SpeedScroll_Change
    IntonationScroll.Value = Logox4.GetLocalIntonation
    IntonationScroll_Change
    RoughnessScroll.Value = Logox4.GetLocalRoughness / 10
    RoughnessScroll_Change
End Sub

Private Sub GlobalNotification_Click()
    If GlobalNotification.Value = 0 Then
        ok = Logox4.NotifyModeLocal
    Else
        ok = Logox4.NotifyModeGlobal
    End If
End Sub

Private Sub IntonationScroll_Change()
    IntonationLabel.Caption = "Intonation: " + CStr(IntonationScroll.Value) + "%"
    ok = Logox4.SetLocalIntonation(IntonationScroll.Value)
End Sub

Private Sub IntonationScroll_Scroll()
    IntonationScroll_Change
End Sub

Private Sub Logox4_NotifyAction(ByVal ActionID As Long, ByVal Value As Long)
    If Action.Value = 1 Then
        Notification.AddItem ("Action " + CStr(ActionID) + "/" + CStr(Action))
    End If
End Sub

Private Sub Logox4_NotifyChunk(ByVal Fonts As Long, ByVal Chunks As Long)
    If Chunk.Value = 1 Then
        Notification.AddItem ("Chunk " + CStr(Fonts) + "/" + CStr(Chunks))
    End If
End Sub

Private Sub Logox4_NotifyMark(ByVal Number As Long)
    If Bookmark.Value = 1 Then
        Notification.AddItem ("Mark " + CStr(Number))
    End If
End Sub

Private Sub Logox4_NotifyMouth(ByVal Param1 As Long, ByVal Param2 As Long)
    If Mouth.Value = 1 Then
        Notification.AddItem ("Mouth " + CStr(Hex(Param1)) + "/" + CStr(Hex(Param2)))
    End If
End Sub

Private Sub Logox4_NotifyParam(ByVal ParamID As Long, ByVal Value As Long)
    If Param.Value = 1 Then
        Notification.AddItem ("Param " + CStr(ID) + "/" + CStr(Value))
    End If
End Sub

Private Sub Logox4_NotifySentence(ByVal Offset As Long, ByVal Length As Long)
    If Sentence.Value = 1 Then
        Notification.AddItem ("Sentence " + CStr(Offset) + "/" + CStr(Length))
        If SentenceMark.Value = 1 Then
            Text.SetFocus
            Text.SelStart = Offset
            Text.SelLength = Length
        End If
    End If
End Sub

Private Sub Logox4_NotifyViseme(ByVal Value As Long)
    If Viseme.Value = 1 Then
        Notification.AddItem ("Viseme " + CStr(Viseme))
    End If
End Sub

Private Sub Logox4_NotifyWord(ByVal Offset As Long, ByVal Length As Long)
    If Word.Value = 1 Then
        Notification.AddItem ("Word " + CStr(Offset) + "/" + CStr(Length))
        If SentenceMark.Value = 0 Then
            Text.SetFocus
            Text.SelStart = Offset
            Text.SelLength = Length
        End If
    End If
End Sub

Private Sub PauseButton_Click()
    If Logox4.IsPaused Then
        ok = Logox4.Resume
        PauseButton.Caption = "Pause"
    Else
        ok = Logox4.Pause
        PauseButton.Caption = "Resume"
    End If
End Sub

Private Sub PitchScroll_Change()
    PitchLabel.Caption = "Pitch: " + CStr(PitchScroll.Value) + " Hz"
    ok = Logox4.SetLocalPitch(PitchScroll.Value * 10)
End Sub

Private Sub PitchScroll_Scroll()
    PitchScroll_Change
End Sub

Private Sub RecordButton_Click()
    SaveForm.Show (vbModal)
    
    Index = SaveForm.Format.ListIndex
    If Index > -1 Then
        If Index Mod 2 = 0 Then
            Channels = 1
        Else
            Channels = 2
        End If
        
        If Index Mod 4 < 2 Then
            BitsPerSamples = 8
        Else
            BitsPerSamples = 16
        End If
        
        Index = CInt(Index / 4 - 0.5)
        
        Select Case Index   ' Evaluate Index.
        Case 0   ' 8kHz
            SamplesPerSec = 8000
        Case 1   ' 11kHz
            SamplesPerSec = 11025
        Case 2   ' 12kHz
            SamplesPerSec = 12000
        Case 3   ' 16kHz
            SamplesPerSec = 16000
        Case 4   ' 22kHz
            SamplesPerSec = 22050
        Case 5   ' 24kHz
            SamplesPerSec = 24000
        Case 6   ' 32kHz
            SamplesPerSec = 32000
        Case 7   ' 44kHz
            SamplesPerSec = 44100
        Case 8   ' 48kHz
            SamplesPerSec = 48000
        End Select
        
        If Logox4.SetAudioFormat(SamplesPerSec, BitsPerSamples, Channels) Then
            MarkState = Bookmark.Value
            Bookmark.Value = 0
            ChunkState = Chunk.Value
            Chunk.Value = 0
            ParamState = Param.Value
            Param.Value = 0
            SentenceState = Sentence.Value
            Sentence.Value = 0
            WordState = Word.Value
            Word.Value = 0
            MouthState = Mouth.Value
            Mouth.Value = 0
            VisemeState = Viseme.Value
            Viseme.Value = 0
            
            ok = Logox4.Record(SaveForm.Filename.Text, Text.Text, 0)
            
            Bookmark.Value = MarkState
            Chunk.Value = ChunkState
            Param.Value = ParamState
            Sentence.Value = SentenceState
            Word.Value = WordState
            Mouth.Value = MouthState
            Viseme.Value = VisemeState
        End If
    End If
End Sub

Private Sub ResetButton_Click()
    ok = Logox4.ResetLocal
    VolumeLabel.Caption = "Volume: " + CStr(Logox4.GetLocalVolume) + " dB"
    VolumeScroll.Value = Logox4.GetLocalVolume
    PitchLabel.Caption = "Pitch: " + CStr(Logox4.GetLocalPitch) + " Hz"
    PitchScroll.Value = Logox4.GetLocalPitch
    SpeedLabel.Caption = "Speed: " + CStr(Logox4.GetLocalSpeed) + "%"
    SpeedScroll.Value = Logox4.GetLocalSpeed
    IntonationLabel.Caption = "Intonation: " + CStr(Logox4.GetLocalIntonation) + "%"
    IntonationScroll.Value = Logox4.GetLocalIntonation
    RoughnessLabel.Caption = "Roughness: " + CStr(Logox4.GetLocalRoughness) + " Hz"
    RoughnessScroll.Value = Logox4.GetLocalRoughness
End Sub

Private Sub RoughnessScroll_Change()
    RoughnessLabel.Caption = "Roughness: " + CStr(RoughnessScroll.Value) + "Hz"
    ok = Logox4.SetLocalRoughness(RoughnessScroll.Value * 10)
End Sub

Private Sub RoughnessScroll_Scroll()
    RoughnessScroll_Change
End Sub

Private Sub SpeakButton_Click()
    ok = Logox4.Speak(Text.Text, CLng(ActionID.Text))
End Sub

Private Sub SpeechFontButton_Click()
    Fonts = Logox4.GetNumberOfFonts
    
    SpeechFontsForm.SpeechFontsGrid.Rows = Fonts + 1
    With SpeechFontsForm.SpeechFontsGrid
        .Row = 0
        .Col = 0
        .ColWidth(0) = 400
        .ColAlignment(0) = flexAlignLeftCenter
        .Text = "ID"
        .Col = 1
        .ColWidth(1) = 3400
        .ColAlignment(1) = flexAlignLeftCenter
        .Text = "Description"
        .Col = 2
        .ColWidth(2) = 2200
        .ColAlignment(2) = flexAlignLeftCenter
        .Text = "Alias"
        .Col = 3
        .ColWidth(3) = 1200
        .ColAlignment(3) = flexAlignLeftCenter
        .Text = "Version"
        .Col = 4
        .ColWidth(4) = 2000
        .ColAlignment(4) = flexAlignLeftCenter
        .Text = "Datum"
        .Col = 5
        .ColWidth(5) = 600
        .ColAlignment(5) = flexAlignCenterCenter
        .Text = "Flags"
        .Col = 6
        .ColWidth(6) = 4200
        .ColAlignment(6) = flexAlignLeftCenter
        .Text = "UUID"
    End With
    
    For nth = 0 To Fonts - 1
        Dim Day As Integer
        Dim Month As Integer
        Dim Year As Integer
        Dim Hour As Integer
        Dim Minute As Integer
        
        ok = Logox4.GetFontDate(nth, Day, Month, Year, Hour, Minute)
        
        With SpeechFontsForm.SpeechFontsGrid
            .Row = nth + 1
            .Col = 0
            .Text = nth + 1
            .Col = 1
            .Text = Logox4.GetFontName(nth)
            .Col = 2
            .Text = Logox4.GetFontAlias(nth)
            .Col = 3
            .Text = Hex(Logox4.GetFontVersion(nth))
            .Col = 4
            .Text = CStr(Day) + "." + CStr(Month) + "." + CStr(Year) + " " + CStr(Hour) + ":" + CStr(Minute)
            .Col = 5
            .Text = Logox4.GetFontFlags(nth)
            .Col = 6
            .Text = "{" + Logox4.GetFontUUID(nth) + "}"
        End With
    Next
    
    SpeechFontsForm.Show (vbModal)
    
    If SpeechFontsForm.Tag = 1 Then
        SpeechFontCombo.ListIndex = SpeechFontsForm.SpeechFontsGrid.RowSel - 1
Rem        ok = Logox4.SetLocalFont()
    End If
End Sub

Private Sub SpeechFontCombo_Click()
    ok = Logox4.SetLocalFont(SpeechFontCombo.ListIndex)
End Sub

Private Sub SpeedScroll_Change()
    SpeedLabel.Caption = "Speed: " + CStr(SpeedScroll.Value) + "%"
    ok = Logox4.SetLocalSpeed(SpeedScroll.Value)
End Sub

Private Sub SpeedScroll_Scroll()
    SpeedScroll_Change
End Sub

Private Sub StopButton_Click()
    ok = Logox4.Stop
End Sub

Private Sub VolumeScroll_Change()
    VolumeLabel.Caption = "Volume: " + CStr(VolumeScroll.Value) + " dB"
    ok = Logox4.SetLocalVolume(VolumeScroll.Value * 10)
End Sub

Private Sub VolumeScroll_Scroll()
    VolumeScroll_Change
End Sub
